/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.trapdoor.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.renderer.DoorRenderer;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraftforge.common.util.ForgeDirection;

public class TrapDoorRenderer
extends DoorRenderer {
    RenderParameters rpTop;
    MalisisModel trapDoorModel;
    MalisisModel slidingTrapDoorModel;

    @Override
    protected void initialize() {
        Cube s = new Cube();
        s.setSize(1.0f, 0.1875f, 1.0f);
        s.interpolateUV();
        this.trapDoorModel = new MalisisModel();
        this.trapDoorModel.addShape("shape", s);
        this.trapDoorModel.storeState();
        s.getFace((String)Face.nameFromDirection((ForgeDirection)ForgeDirection.UP)).getParameters().calculateAOColor.set(true);
        s = new Cube();
        s.setSize(1.0f, 0.09375f, 1.0f);
        s.interpolateUV();
        this.slidingTrapDoorModel = new MalisisModel();
        this.slidingTrapDoorModel.addShape("shape", s);
        this.slidingTrapDoorModel.storeState();
        this.initParams();
    }

    @Override
    public void render() {
        if (this.renderType == RenderType.ISBRH_WORLD) {
            return;
        }
        if (this.renderType == RenderType.ISBRH_INVENTORY) {
            this.model = this.block == MalisisDoors.Blocks.slidingTrapDoor ? this.slidingTrapDoorModel : this.trapDoorModel;
            this.model.resetState();
            this.model.translate(0.0f, 0.5f, 0.0f);
            this.model.render((MalisisRenderer)this, this.rp);
            return;
        }
        super.render();
    }

    @Override
    protected void setup() {
        this.model = this.block == MalisisDoors.Blocks.slidingTrapDoor ? this.slidingTrapDoorModel : this.trapDoorModel;
        this.model.resetState();
        float angle = 0.0f;
        if (this.direction == 1) {
            angle = 180.0f;
        } else if (this.direction == 2) {
            angle = 90.0f;
        } else if (this.direction == 3) {
            angle = 270.0f;
        }
        this.model.rotate(angle, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.topBlock) {
            this.model.translate(0.0f, 0.8125f, 0.0f);
        }
        this.rp.brightness.set(this.block.func_149677_c(this.world, this.x, this.y, this.z));
    }

    @Override
    protected void renderTileEntity() {
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        this.setup();
        if (this.tileEntity.getMovement() != null) {
            Animation[] anims = this.tileEntity.getMovement().getAnimations(this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        Shape s = this.model.getShape("shape");
        Face f = s.getFace(Face.nameFromDirection(ForgeDirection.UP));
        s.applyMatrix();
        f.getParameters().aoMatrix.set(f.calculateAoMatrix(ForgeDirection.UP));
        this.model.render((MalisisRenderer)this, this.rp);
    }

    @Override
    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return dbp.func_73110_b() == this.x && dbp.func_73109_c() == this.y && dbp.func_73108_d() == this.z;
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

